/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.ui.debug;

import com.jediterm.terminal.LoggingTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.ui.debug.ControlSequenceSettings;
import com.jediterm.ui.debug.ControlSequenceVisualizer;
import com.jediterm.ui.debug.DebugBufferType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BoundedRangeModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 22\u00020\u0001:\u0003012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u000eH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0017H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010+\u001a\u00020\u001dJ\b\u0010,\u001a\u00020\u0012H\u0002J\u0018\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00063"}, d2={"Lcom/jediterm/ui/debug/TerminalDebugView;", "", "terminal", "Lcom/jediterm/terminal/ui/TerminalSession;", "<init>", "(Lcom/jediterm/terminal/ui/TerminalSession;)V", "loggingTtyConnector", "Lcom/jediterm/terminal/LoggingTtyConnector;", "typeComboBox", "Ljavax/swing/JComboBox;", "Lcom/jediterm/ui/debug/DebugBufferType;", "controlSequenceSettingsView", "Lcom/jediterm/ui/debug/TerminalDebugView$ControlSequenceSettingsView;", "slider", "Ljavax/swing/JSlider;", "spinner", "Ljavax/swing/JSpinner;", "resultPanel", "Ljavax/swing/JPanel;", "timer", "Ljavax/swing/Timer;", "listeners", "", "Lcom/jediterm/ui/debug/TerminalDebugView$StateChangeListener;", "createViewArea", "Ljavax/swing/JTextArea;", "createControlSequenceArea", "createSlider", "update", "", "syncSliderToSpinner", "addListener", "listener", "getControlSequencesVisualization", "", "settings", "Lcom/jediterm/ui/debug/ControlSequenceSettings;", "stateIndex", "", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "stop", "createNorthPanel", "createResultPanel", "viewArea", "controlSequencesArea", "StateChangeListener", "ControlSequenceSettingsView", "Companion", "JediTerm"})
@SourceDebugExtension(value={"SMAP\nTerminalDebugView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalDebugView.kt\ncom/jediterm/ui/debug/TerminalDebugView\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,207:1\n37#2:208\n36#2,3:209\n*S KotlinDebug\n*F\n+ 1 TerminalDebugView.kt\ncom/jediterm/ui/debug/TerminalDebugView\n*L\n11#1:208\n11#1:209,3\n*E\n"})
public final class TerminalDebugView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalSession terminal;
    @NotNull
    private final LoggingTtyConnector loggingTtyConnector;
    @NotNull
    private final JComboBox<DebugBufferType> typeComboBox;
    @NotNull
    private final ControlSequenceSettingsView controlSequenceSettingsView;
    @NotNull
    private final JSlider slider;
    @NotNull
    private final JSpinner spinner;
    @NotNull
    private final JPanel resultPanel;
    @NotNull
    private final Timer timer;
    @NotNull
    private final List<StateChangeListener> listeners;
    public static final int INITIAL = -1;

    public TerminalDebugView(@NotNull TerminalSession terminal) {
        Intrinsics.checkNotNullParameter(terminal, "terminal");
        this.terminal = terminal;
        TtyConnector ttyConnector = this.terminal.getTtyConnector();
        Intrinsics.checkNotNull(ttyConnector, "null cannot be cast to non-null type com.jediterm.terminal.LoggingTtyConnector");
        this.loggingTtyConnector = (LoggingTtyConnector)((Object)ttyConnector);
        Collection $this$toTypedArray$iv = EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.typeComboBox = new JComboBox<DebugBufferType>(thisCollection$iv.toArray(new DebugBufferType[0]));
        this.controlSequenceSettingsView = new ControlSequenceSettingsView();
        this.listeners = new CopyOnWriteArrayList();
        JTextArea viewArea = this.createViewArea();
        JTextArea controlSequencesArea = this.createControlSequenceArea();
        this.slider = this.createSlider();
        this.spinner = new JSpinner();
        this.resultPanel = this.createResultPanel(viewArea, controlSequencesArea);
        this.typeComboBox.addItemListener(arg_0 -> TerminalDebugView._init_$lambda$0(this, arg_0));
        this.slider.addChangeListener(arg_0 -> TerminalDebugView._init_$lambda$1(this, arg_0));
        this.spinner.addChangeListener(arg_0 -> TerminalDebugView._init_$lambda$2(this, arg_0));
        this.update();
        this.timer = new Timer(1000, arg_0 -> TerminalDebugView._init_$lambda$3(this, arg_0));
        this.timer.setRepeats(true);
        this.timer.start();
    }

    private final JTextArea createViewArea() {
        JTextArea viewArea = TerminalDebugView.Companion.createTextArea();
        this.addListener(new StateChangeListener(this, viewArea){
            private String myLastText;
            final /* synthetic */ TerminalDebugView this$0;
            final /* synthetic */ JTextArea $viewArea;
            {
                this.this$0 = $receiver;
                this.$viewArea = $viewArea;
            }

            public void stateChanged(DebugBufferType type, ControlSequenceSettings controlSequenceSettings, int stateIndex) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), "type");
                Intrinsics.checkNotNullParameter(controlSequenceSettings, "controlSequenceSettings");
                String string = type.getValue(TerminalDebugView.access$getTerminal$p(this.this$0), stateIndex);
                Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                String text = string;
                if (!Intrinsics.areEqual(text, this.myLastText)) {
                    this.$viewArea.setText(text);
                    this.myLastText = text;
                }
            }
        });
        return viewArea;
    }

    private final JTextArea createControlSequenceArea() {
        JTextArea controlSequenceArea = TerminalDebugView.Companion.createTextArea();
        this.addListener(new StateChangeListener(this, controlSequenceArea){
            private String myLastText;
            final /* synthetic */ TerminalDebugView this$0;
            final /* synthetic */ JTextArea $controlSequenceArea;
            {
                this.this$0 = $receiver;
                this.$controlSequenceArea = $controlSequenceArea;
            }

            public void stateChanged(DebugBufferType type, ControlSequenceSettings controlSequenceSettings, int stateIndex) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), "type");
                Intrinsics.checkNotNullParameter(controlSequenceSettings, "controlSequenceSettings");
                String controlSequencesVisualization = TerminalDebugView.access$getControlSequencesVisualization(this.this$0, controlSequenceSettings, stateIndex);
                if (!Intrinsics.areEqual(controlSequencesVisualization, this.myLastText)) {
                    this.$controlSequenceArea.setText(controlSequencesVisualization);
                    this.myLastText = controlSequencesVisualization;
                }
                this.$controlSequenceArea.setLineWrap(controlSequenceSettings.getWrapLines());
            }
        });
        return controlSequenceArea;
    }

    private final JSlider createSlider() {
        JSlider slider = new JSlider(-1, -1, -1);
        slider.setMajorTickSpacing(10);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        return slider;
    }

    private final void update() {
        Object object = this.typeComboBox.getSelectedItem();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.jediterm.ui.debug.DebugBufferType");
        DebugBufferType type = (DebugBufferType)((Object)object);
        int newMinimum = this.loggingTtyConnector.getLogStart();
        int newMaximum = newMinimum + this.loggingTtyConnector.getChunks().size();
        boolean initialize = this.slider.getValue() == -1;
        this.slider.setMinimum(newMinimum);
        this.slider.setMaximum(newMaximum);
        if (initialize) {
            this.slider.setValue(newMaximum);
        }
        this.syncSliderToSpinner();
        int stateIndex = this.slider.getValue() - this.slider.getMinimum();
        ControlSequenceSettings controlSequenceSettings = this.controlSequenceSettingsView.get();
        for (StateChangeListener listener : this.listeners) {
            listener.stateChanged(type, controlSequenceSettings, stateIndex);
        }
    }

    private final void syncSliderToSpinner() {
        SpinnerModel spinnerModel = this.spinner.getModel();
        Intrinsics.checkNotNull(spinnerModel, "null cannot be cast to non-null type javax.swing.SpinnerNumberModel");
        SpinnerNumberModel spinnerModel2 = (SpinnerNumberModel)spinnerModel;
        BoundedRangeModel sliderModel = this.slider.getModel();
        if (!(Intrinsics.areEqual(spinnerModel2.getValue(), (Object)sliderModel.getValue()) && Intrinsics.areEqual(spinnerModel2.getMinimum(), (Object)sliderModel.getMinimum()) && Intrinsics.areEqual(spinnerModel2.getMaximum(), (Object)sliderModel.getMaximum()))) {
            this.spinner.setModel(new SpinnerNumberModel(sliderModel.getValue(), sliderModel.getMinimum(), sliderModel.getMaximum(), 1));
        }
    }

    private final void addListener(StateChangeListener listener) {
        this.listeners.add(listener);
    }

    private final String getControlSequencesVisualization(ControlSequenceSettings settings, int stateIndex) {
        List<char[]> chunks = this.loggingTtyConnector.getChunks().subList(0, stateIndex);
        return ControlSequenceVisualizer.INSTANCE.getVisualizedString(this.loggingTtyConnector.getLogStart(), chunks, settings);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.resultPanel;
    }

    public final void stop() {
        this.timer.stop();
    }

    private final JPanel createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.typeComboBox, "Center");
        panel.add((Component)this.controlSequenceSettingsView.getPanel(), "East");
        return panel;
    }

    private final JPanel createResultPanel(JTextArea viewArea, JTextArea controlSequencesArea) {
        JPanel resultPanel = new JPanel(new BorderLayout(0, 0));
        resultPanel.add((Component)this.createNorthPanel(), "North");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(new JScrollPane(viewArea));
        splitPane.setRightComponent(new JScrollPane(controlSequencesArea));
        resultPanel.add((Component)splitPane, "Center");
        resultPanel.add((Component)TerminalDebugView.Companion.createBottomPanel(this.slider, this.spinner), "South");
        return resultPanel;
    }

    private static final void _init_$lambda$0(TerminalDebugView this$0, ItemEvent it) {
        this$0.update();
    }

    private static final void _init_$lambda$1(TerminalDebugView this$0, ChangeEvent it) {
        this$0.update();
    }

    private static final void _init_$lambda$2(TerminalDebugView this$0, ChangeEvent it) {
        JSlider jSlider = this$0.slider;
        Object object = this$0.spinner.getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
        jSlider.setValue((Integer)object);
        this$0.update();
    }

    private static final void _init_$lambda$3(TerminalDebugView this$0, ActionEvent it) {
        this$0.update();
    }

    public static final /* synthetic */ TerminalSession access$getTerminal$p(TerminalDebugView $this) {
        return $this.terminal;
    }

    public static final /* synthetic */ String access$getControlSequencesVisualization(TerminalDebugView $this, ControlSequenceSettings settings, int stateIndex) {
        return $this.getControlSequencesVisualization(settings, stateIndex);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jediterm/ui/debug/TerminalDebugView$Companion;", "", "<init>", "()V", "createBottomPanel", "Ljavax/swing/JPanel;", "slider", "Ljavax/swing/JSlider;", "spinner", "Ljavax/swing/JSpinner;", "createTextArea", "Ljavax/swing/JTextArea;", "INITIAL", "", "JediTerm"})
    public static final class Companion {
        private Companion() {
        }

        private final JPanel createBottomPanel(JSlider slider, JSpinner spinner) {
            JPanel stateIndexPanel = new JPanel(new GridBagLayout());
            stateIndexPanel.add((Component)slider, new GridBagConstraints(0, 0, 1, 1, 0.9, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            stateIndexPanel.add((Component)spinner, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            return stateIndexPanel;
        }

        private final JTextArea createTextArea() {
            JTextArea jTextArea;
            JTextArea it = jTextArea = new JTextArea();
            boolean bl = false;
            it.setEditable(false);
            it.setFont(new Font("Monospaced", 0, 14));
            return jTextArea;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jediterm/ui/debug/TerminalDebugView$ControlSequenceSettingsView;", "", "<init>", "(Lcom/jediterm/ui/debug/TerminalDebugView;)V", "showChunkId", "Ljavax/swing/JCheckBox;", "useTeseq", "showInvisibleCharacters", "wrapLines", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "addAndUpdateOnChange", "", "checkbox", "get", "Lcom/jediterm/ui/debug/ControlSequenceSettings;", "JediTerm"})
    private final class ControlSequenceSettingsView {
        @NotNull
        private final JCheckBox showChunkId = new JCheckBox("Show chunk id", true);
        @NotNull
        private final JCheckBox useTeseq = new JCheckBox("Use teseq", false);
        @NotNull
        private final JCheckBox showInvisibleCharacters = new JCheckBox("Show invisible characters", true);
        @NotNull
        private final JCheckBox wrapLines = new JCheckBox("Wrap lines", true);
        @NotNull
        private final JPanel panel = new JPanel(new FlowLayout());

        public ControlSequenceSettingsView() {
            this.addAndUpdateOnChange(this.showChunkId);
            this.addAndUpdateOnChange(this.useTeseq);
            this.addAndUpdateOnChange(this.showInvisibleCharacters);
            this.addAndUpdateOnChange(this.wrapLines);
        }

        @NotNull
        public final JPanel getPanel() {
            return this.panel;
        }

        private final void addAndUpdateOnChange(JCheckBox checkbox) {
            this.panel.add(checkbox);
            checkbox.addChangeListener(arg_0 -> ControlSequenceSettingsView.addAndUpdateOnChange$lambda$0(TerminalDebugView.this, arg_0));
        }

        @NotNull
        public final ControlSequenceSettings get() {
            return new ControlSequenceSettings(this.showChunkId.isSelected(), this.useTeseq.isSelected(), this.showInvisibleCharacters.isSelected(), this.wrapLines.isSelected());
        }

        private static final void addAndUpdateOnChange$lambda$0(TerminalDebugView this$0, ChangeEvent it) {
            this$0.update();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DebugBufferType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])DebugBufferType.values());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bb\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lcom/jediterm/ui/debug/TerminalDebugView$StateChangeListener;", "", "stateChanged", "", "type", "Lcom/jediterm/ui/debug/DebugBufferType;", "controlSequenceSettings", "Lcom/jediterm/ui/debug/ControlSequenceSettings;", "stateIndex", "", "JediTerm"})
    private static interface StateChangeListener {
        public void stateChanged(@NotNull DebugBufferType var1, @NotNull ControlSequenceSettings var2, int var3);
    }
}

